import logging
import requests

requests.packages.urllib3.disable_warnings()

logging.getLogger("urllib3.connectionpool").setLevel(logging.ERROR)


class SafeFormatter(logging.Formatter):
    def format(self, record):
        try:
            return super().format(record)
        except (TypeError, ValueError) as e:
            if record.msg:
                return "Error in log formatting: %s \nMessage: %s" % (str(e), record.msg)

            return "Error in log formatting: %s" % (str(e))


def setup_logger():
    logger = logging.getLogger()
    logger.setLevel(logging.INFO)

    if not logger.handlers:
        console_handler = logging.StreamHandler()
        formatter = SafeFormatter('[%(asctime)s] - %(levelname)s - %(message)s',
                                  datefmt='%Y-%m-%d %H:%M:%S')
        console_handler.setFormatter(formatter)
        logger.addHandler(console_handler)

    return logger
